// Import the Next Head element for supplying metadata, etc.
import Head from 'next/head'

// Import the React modules for state variables and effects.
import {useState, useEffect} from 'react'

// Define the blog listing page function, which loads and
// displays the blog listing.
export default function Blog() {
  // Initialize the React state variables for the website data
  // and the blog listing.
  const [homeData, setHomeData] = useState([]);
  const [postsData, setPostsData] = useState([]);

  // Load the home page data from the Next API endpoint.
  useEffect(() => {
    fetch('/api/home')
      .then((res) => res.json())
      .then((data) => setHomeData(data))
  }, [])

  // Load the blog listing data from the Next API endpoint.
  useEffect(() => {
    fetch('/api/posts')
      .then((res) => res.json())
      .then((data) => setPostsData(data))
  }, [])

  // Render the page template.
  return (
    <div>
      <Head>
        <title>{homeData.name} | Blog</title>
        <meta name='description' content='Generated by create next app' />
        <link rel='icon' href='/favicon.ico' />
      </Head>

      <div className="text-center align-middle">
        <h1 className="text-xl">
          {homeData.name} | The Blog
        </h1>
      </div>

      <div>
        <div className="m-2">
          <ul className="list-inside list-disc">
            {postsData.map((postData) => (
              <li key={postData.id}>
                <a className="underline decoration-blue-400 decoration-dashed" href={ '/posts/' + postData.id }>{postData.attributes.name}</a>
              </li>
            ))}
          </ul>
        </div>
      </div>
    </div>
  )
}

